-- JDAM-ER Mk83 by Currenthill

local MIG29MU2_JDAM_ER_warhead = 
{
    mass                 = 340, 
    caliber              = 457,
    expl_mass            = 340,
    piercing_mass        = 0.0,
    other_factors        = { 1.0, 1.0, 1.0 },
    concrete_factors     = { 1.3, 1.0, 1.5 },
    concrete_obj_factor  = 0.5,
    obj_factors          = { 1.0, 1.0, 1.0 },
    cumulative_factor    = 0.0,
    cumulative_thickness = 0.0,
}

MIG29_MU2_JDAM_ER =
{
    category        = CAT_MISSILES,
    name            = "MIG29MU2_JDAMER",
    user_name       = _("JDAM-ER Mk83"),
    scheme          = "JSOW_C",
    class_name      = "wAmmunitionCruise",
    model           = "MiG-29MU2_JDAM-ER",
    mass            = 525,
    
    wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},

    Escort          = 0,
    Head_Type       = 5,
    sigma           = {5, 5, 5},
    M               = 525,
    H_max           = 28000.0,
    H_min           = 100,
    Diam            = 330.0,
    Cx_pil          = 8,
    D_max           = 80000.0,
    D_min           = 5000.0,
    Head_Form       = 1,
    Life_Time       = 9999,
    Nr_max          = 10,
    v_min           = 10.0,
    v_mid           = 200.0,
    Mach_max        = 1.7,
    t_b             = 0.0,
    t_acc           = 0.0,
    t_marsh         = 0.0,
    Range_max       = 80000.0,
    H_min_t         = 0.0,
    Fi_start        = 3.14152,
    Fi_rak          = 3.14152,
    Fi_excort       = 3.14152,
    Fi_search       = 99.9,
    OmViz_max       = 99.9,
    X_back          = 0.0,
    Y_back          = 0.0,
    Z_back          = 0.0,
    Reflection      = 0.2,
    KillDistance    = 0.0,
       
    shape_table_data =
    {
        {
            name     = "MIG29MU2_JDAMER",
            file     = "MiG-29MU2_JDAM-ER",
            life     = 1,
            fire     = { 0, 1},
            username = _("JDAM-ER"),
            index    = WSTYPE_PLACEHOLDER,
        },
    },
    
    fm = {
        mass                = 525,  
        caliber             = 0.377,  
        cx_coeff            = {1, 0.82, 0.8, 0.15, 1.5},
        L                   = 3.09,
        I                   = 1 / 12 * 525 * 3.09 * 3.09,
        Ma                  = 2,
        Mw                  = 7,
        wind_sigma          = 0.0,
        wind_time           = 0.0,
        Sw                  = 1.1,
        dCydA               = {0.07, 0.036},
        A                   = 0.1,
        maxAoa              = 0.4,
        finsTau             = 1.2,
        Ma_x                = 2,
        Ma_z                = 2,
        Mw_x                = 1.4,
        
        addDeplSw           = 0.6,
        no_wings_A_mlt      = 2,
        wingsDeplProcTime   = 5,
        wingsDeplDelay      = 9999,
        no_wings_cx_coeff   = {1, 0.45, 0.8, 0.10, 1.55},

        release_rnd         = 0.3,
        release_rnd_x       = 0.0,
    },
    
    seeker = {
        coalition                    = 2,
        coalition_rnd_coeff          = 5.0,
        can_update_target_pos        = 1,
    },
    
    control_block = {
        seeker_activation_dist       = 7000,
        default_cruise_height        = -1,
        obj_sensor                   = 0,
        can_update_target_pos        = 0,
        turn_before_point_reach      = 1,
        turn_hor_N                   = 2.2,
        turn_max_calc_angle_deg      = 90,
        turn_point_trigger_dist      = 100,
    },
    
    autopilot = {
        delay                       = 0.5,
        K                           = 160,
        Ki                          = 0.00005,
        Kg                          = 6,
        nw_K                        = 32,
        nw_Ki                       = 0.00005,
        nw_Kg                       = 1.8,
        finsLimit                   = 0.8,
        useJumpByDefault            = 0,
        J_Power_K                   = 4.8,
        J_Diff_K                    = 3.2,
        J_Int_K                     = 0.0,
        J_Angle_W                   = 0.1,
        Kp_hor_err                  = 240,
        hKp_err                     = 50,
        Kx                          = 0.014,
        Kxd                         = 0.0,
        K_err_mlt                   = 5.0,
        K_roll_diff_mlt             = 5.0,
        roll_limit                  = 1.3,
        w_limit                     = 1.3,
        fins_limit_x                = 0.25,
        egm_Angle_K                 = 0.2,
        egm_FinAngle_K              = 0.3,
        egm_add_power_K             = 0.2,
        wings_depl_fins_limit_K     = 0.3,
        err_new_wlos_k              = 1.0,
        err_aoaz_k                  = 0,
        err_aoaz_sign_k             = 0.0,

        alternative_roll_params     = 1,
        w_x_limit                   = 1,
        err_limit                   = 0.5,
        err_min                     = 0.04,
        corr_err_min                = 0.006,
        roll_limit                  = 1.3,
        fins_limit_x                = 0.01,
        K_err_mlt                   = 4.0,
        K_roll_diff_mlt             = 4.0,
        Kx                          = 0.04,
        
        alternative_jump_params     = 0,
        K_pitch_diff_mlt            = 5.0,
        w_limit                     = 0.5,
        Kpj                         = 0.5,
    },
        
    warhead     = MIG29MU2_JDAM_ER_warhead,
    warhead_air = MIG29MU2_JDAM_ER_warhead,
}

declare_weapon(MIG29_MU2_JDAM_ER)

declare_loadout({
    category         = CAT_BOMBS,
    CLSID            = '{MIG29MU2_JDAM-ER}',
    attribute        = MIG29_MU2_JDAM_ER.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0025,
    Picture          = "MIG29MU2_JDAMER.png",
    displayName      = _("JDAM-ER - 450 kg GPS Guided Mk-83 GP bomb"),
    Weight           = 934,
    Elements         = {
        [1] = {
            ShapeName = "MiG-29MU2_JDAM-ER",
        }
    },
    ejectImpulse     = 525,	
    ejectDirection   = {0, -1, 0},
})

